﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

$tsenv = New-Object -ComObject Microsoft.SMS.TSEnvironment
$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"


Write-Output "---------------------------------------------------------"
Write-Output "Starting Windows Capability Language Detection"
CMTraceLog -Message  "Starting Windows Capability Language Detection" -Type 1 -LogFile $LogFile -Component $Component

$WinLang = (Get-WinSystemLocale).name
$tsenv.Value('SMSTS_WinSystemLocale') = $WinLang
Write-Output "WinSystemLocale = $WinLang"
CMTraceLog -Message " WinSystemLocale: $WinLang" -Type 1 -LogFile $LogFile -Component "WinSystemLocale"
$tsenv.Value("Lang_$($WinLang)") = $TRUE
Write-Output " Created: Lang_$($WinLang) an set to True"
CMTraceLog -Message " Created: Lang_$($WinLang) an set to True" -Type 1 -LogFile $LogFile -Component "WinSystemLocale"

$NonENUSLangs = Get-WindowsCapability -Online | Where-Object {$_.State -eq "Installed" -and $_.Name -match "Language.Basic" -and $_.Name -notmatch "en-US"}
if ($NonENUSLangs.count -ge 1)
    {
    Write-Output "Found Additional Windows Language Capabilities besides $WinLang, Setting Variable Lang_WinCapabilities to True"
    CMTraceLog -Message "Found Additional Windows Language Capabilities besides en-US, Setting Variable Lang_WinCapabilities to True" -Type 1 -LogFile $LogFile -Component "WindowsCapability"
    $tsenv.Value("Lang_WinCapabilities") = $TRUE
    Foreach ($NonENUSLang in $NonENUSLangs)
        {
        $CurrentLang = $(($NonENUSLang.Name).Split("~")[-2])
        Write-Output " Found: $CurrentLang"
        CMTraceLog -Message " Found: $CurrentLang" -Type 1 -LogFile $LogFile -Component "WindowsCapability"
        $tsenv.Value("Lang_$($CurrentLang)") = $TRUE
        Write-Output " Created : Lang_$($CurrentLang) an set to True"
        CMTraceLog -Message " Created : Lang_$($CurrentLang) an set to True" -Type 1 -LogFile $LogFile -Component "WindowsCapability"
        }
    }
else
    {
     Write-Output "NO Found Additional Windows Language Capabilities besides $WinLang"
     CMTraceLog -Message "NO Found Additional Windows Language Capabilities besides $WinLang" -Type 1 -LogFile $LogFile -Component "WindowsCapability"
    }

Write-Output "More Details here in the WaaS_LangPack.log"
Write-Output "---------------------------------------------------------"